﻿//////////////////////////////////////////////
// BmpBitFieldCompressor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class ImageView ;

	struct AlignmentDescriptor ;
}

namespace nkImages::bmp
{
	class BmpDibHeader ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::bmp
{
	class BmpBitFieldCompressor final
	{
		public :

			// Compression
			static void prepareDibHeader (BmpDibHeader& header) ;
			static unsigned int getCompressedSize (const ImageView& image) ;
			static bool compress (const ImageView& image, nkMemory::BufferView<unsigned char>& output) ;

			// Decompression
			static nkMemory::Buffer decompress (const BmpDibHeader& header, const nkMemory::BufferView<unsigned char>& data, const AlignmentDescriptor& alignmentDescriptor) ;
	} ;
}